//
//  GMSSettingsURLViewController.m
//  GMS Sample
//
//  Created by Arkady on 8/8/13.
//  Copyright (c) 2013 Genesys. All rights reserved.
//

#import "GMSSettingsURLViewController.h"
#import "GMSAppDelegate.h"
#import "GMSSettingsURLAddViewController.h"
#import "GMSSettingsTableViewController.h"

@interface GMSSettingsURLViewController ()
{
    GMSAppDelegate *appDelegate;
}

@end

@implementation GMSSettingsURLViewController


- (void)viewDidLoad
{
    [super viewDidLoad];
    appDelegate = (GMSAppDelegate*)[[UIApplication sharedApplication] delegate];
}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    // Return the number of sections.
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    // Return the number of rows in the section.
    return [appDelegate.serverURLs count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"GMSURLCell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    
    // Configure the cell...
    cell.textLabel.text = appDelegate.serverURLs[indexPath.row];
    
    cell.imageView.alpha = (indexPath.row == appDelegate.serverURLSelected) ? 1 : 0;

    return cell;
}

#pragma mark - Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    appDelegate.serverURLSelected = indexPath.row;
    

    UITableViewCell *cell = [tableView cellForRowAtIndexPath:indexPath];
    
    [tableView reloadData];
    double delayInSeconds = 0.25;
    dispatch_time_t popTime = dispatch_time(DISPATCH_TIME_NOW, delayInSeconds * NSEC_PER_SEC);
    dispatch_after(popTime, dispatch_get_main_queue(), ^(void){
        [self.navigationController popViewControllerAnimated:YES];
    });
}

// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        if (appDelegate.serverURLSelected == indexPath.row && appDelegate.serverURLSelected == [appDelegate.serverURLs count] - 1) {
            appDelegate.serverURLSelected--;
        }
        [appDelegate.serverURLs removeObjectAtIndex:indexPath.row];
        
        [tableView deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:YES];
        [tableView reloadData];
    }
}

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    GMSSettingsURLAddViewController *urlAddVC = segue.destinationViewController;
    urlAddVC.parentTableView = self.tableView;
    
    if ([segue.identifier isEqualToString:@"addURL"]) {
        appDelegate.serverURLSelected = -1;
    }

    if ([segue.identifier isEqualToString:@"editURL"]) {
        urlAddVC.editIndex = [self.tableView indexPathForCell:sender].row;
    }
}

@end
